
// TestBoostAsioServerMultiProcessDlg.h : wb_[ t@C
//

#pragma once

#include "rsocket.h"
#include "RLib/Base/RPostMessageToUIThread.h"

// CTestBoostAsioServerMultiProcessDlg _CAO
class CTestBoostAsioServerMultiProcessDlg
	:public CDialog
	,public RLib::CRPostMessageToUIThread<CString>
{
	boost::thread				m_thread;
	boost::asio::io_service		m_ioService;
	std::auto_ptr<boost::asio::io_service::work>	m_apWork;

	void PostMessage(const CString &message)
		{
			RLib::CRPostMessageToUIThread<CString>::PostMessage(message);
		}
	
	static CString GetTextAddress(const boost::asio::ip::tcp::socket::endpoint_type &endpoint)
		{
			CString s;
			s.Format(_T("%s:%d"),CString(endpoint.address().to_string().c_str()),endpoint.port());
			return s;
		}

	class CSocketApp : public CRSocket::CSocket
	{
	public:
		CTestBoostAsioServerMultiProcessDlg	&m_dlg;
		CSocketApp(CTestBoostAsioServerMultiProcessDlg &dlg,boost::asio::io_service &ioService)
			:CRSocket::CSocket(ioService)
			,m_dlg(dlg)
			{}
		virtual void OnDataReceive(const boost::shared_ptr<const std::vector<char>> &spBuffer)
			{
				CString sMessage;
				{
					std::vector<char> v(*spBuffer);
					v.push_back(NULL);
					sMessage = CString(&v[0]);
				}

				CString s;
				s.Format(_T("%s -> %s"),GetTextAddress(GetRemoteEndpoint()), sMessage);

				m_dlg.PostMessage(s);

			}
	};

	class CAcceptorApp : public CRSocket::CAcceptor
	{
	public:
		CTestBoostAsioServerMultiProcessDlg	&m_dlg;
		std::set<boost::shared_ptr<CRSocket::CSocket>>	m_mapSocket;
		CAcceptorApp(CTestBoostAsioServerMultiProcessDlg &dlg,boost::asio::io_service &ioService)
			:CRSocket::CAcceptor(ioService)
			,m_dlg(dlg)
			{}
		virtual std::auto_ptr<CRSocket::CSocket> OnCreateSocket(boost::asio::io_service &ioService)
			{
				return std::auto_ptr<CRSocket::CSocket>(new CSocketApp(m_dlg,ioService));
			}
		virtual void OnAccept(boost::shared_ptr<CRSocket::CSocket> spSocket)
			{
				m_mapSocket.insert(spSocket);

				CString s;
				s.Format(_T("%s -> OnAccept"),GetTextAddress(spSocket->GetRemoteEndpoint()));
				m_dlg.PostMessage(s);

				// ǂݍݑ҂Jn
				spSocket->Read();
			}
	};
	CAcceptorApp	m_acceptor;



	virtual void OnReceiveMessage(std::list<CString> &listMessage)
		{
			__super::OnReceiveMessage(listMessage);

			for(std::list<CString>::iterator i=listMessage.begin(); i!=listMessage.end(); i++ ){
				CEdit *pEdit = static_cast<CEdit*>(GetDlgItem(IDC_EDIT1));
				pEdit->SetSel( LONG_MAX, -1 );
				pEdit->ReplaceSel(_T("\xd\xa") + *i);
			}

		}

// RXgNV
public:
	CTestBoostAsioServerMultiProcessDlg(CWnd* pParent = NULL);	// WRXgN^

// _CAO f[^
	enum { IDD = IDD_TESTBOOSTASIOSERVERMULTIPROCESS_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV T|[g

// 
protected:
	HICON m_hIcon;

	// ꂽAbZ[W蓖Ċ֐
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonPortlisten();
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedDup();
};
