#include "stdafx.h"
#include "RSocket.h"

namespace asio = boost::asio;


void CRSocket::CSocket::Connect(const std::string &sDomain,const std::string &sPort)
{
	struct F{
		static void Connect(CSocket &body,const std::string sDomain,const std::string sPort)
			{
				asio::ip::tcp::socket &socket = body.m_socket;
				asio::io_service &ioService = socket.get_io_service();

				asio::ip::tcp::resolver resolver(ioService);
				asio::ip::tcp::resolver::query query(sDomain,sPort);
				asio::ip::tcp::resolver::iterator iterator = resolver.resolve(query);
				while(true){
					try{
						socket.connect(*iterator);				// rŏ܂Ȃ悤ɓ֐g
						body.OnConnect();						// ڑʒm
						body.Read();							// ǂݍݑ҂Jn
						break;
					}catch( std::exception& ){
						iterator++;
						if( iterator != asio::ip::tcp::resolver::iterator() ){	// 
							socket.close();
							continue;
						}
						throw;
					}
				}
			}
	};
	m_socket.get_io_service().post( boost::bind(&F::Connect,boost::ref(*this),sDomain,sPort) );
}

// ǂݍݑ҂̊Jn
void CRSocket::CSocket::Read()
{
	struct F{
		// f[^ǂݍ݃nh
		static void OnReadBody(const boost::system::error_code &error,CSocket &This,boost::shared_ptr<std::vector<char>> spBuffer)
			{
				if( error ){	// Error
					This.OnError(error);
					This.m_socket.close();
					return;
				}
				This.OnDataReceive(spBuffer);			// ʒm
				This.Read();							// ̓ǂݍݑ҂
			}

		// wb_ǂݍ݃nh
		static void OnReadHeader(const boost::system::error_code &error,CSocket &This,boost::shared_ptr<boost::uint32_t> spSize)
			{
				if( error ){	// Error
					This.OnError(error);
					This.m_socket.close();
					return;
				}

				// obt@쐬
				boost::shared_ptr<std::vector<char>> spBuffer(new std::vector<char>(*spSize));
				// f[^ǂݍݑ҂
				asio::async_read(
					This.m_socket,
					asio::buffer(*spBuffer),
					boost::bind(
						&F::OnReadBody,
						_1,
						boost::ref(This),
						spBuffer));
			}
	};

	// wb_ǂݍݑ҂
	boost::shared_ptr<boost::uint32_t> spSize(new boost::uint32_t);
	asio::async_read(
		m_socket,
		asio::buffer(spSize.get(),sizeof(*spSize.get())),
		boost::bind(
			&F::OnReadHeader,
			_1,
			boost::ref(*this),
			spSize));
}

void CRSocket::CSocket::Send(boost::shared_ptr<const std::vector<char>> spData)
{
	struct F{
		// f[^Mnh
		static void OnWrite(const boost::system::error_code &error,CSocket &This,boost::shared_ptr<const std::vector<char>> spData)
			{
				if( error ){	// Error
					This.OnError(error);
					This.m_socket.close();
					return;
				}
			}
	};

	if( spData && !spData->empty() ){

		// wb_tMf[^
		const boost::uint32_t t = spData->size();
		std::vector<char> *p = new std::vector<char>( sizeof(t) + t );
		::memcpy( &(*p)[0], &t, sizeof(t) );		// TCY(GfBAl͂܂)
		::memcpy( &(*p)[sizeof(t)], &(*spData)[0], t );
		boost::shared_ptr<const std::vector<char>> sp(p);

		// async_write
		asio::async_write(
			m_socket,
			asio::buffer(*sp),
			boost::bind(
				&F::OnWrite,
				_1,
				boost::ref(*this),
				sp));
	}
}


///////////////////////////////////////////////////////////

CRSocket::CAcceptor::CAcceptor(asio::io_service &ioService)
:m_acceptor(ioService)
{
}

CRSocket::CAcceptor::~CAcceptor()
{
	BOOST_ASSERT( !m_acceptor.is_open() );		// ĂׂB( io_service  run 甲܂ł݂͑Ƃׂ)
}

void CRSocket::CAcceptor::Close()
{
	m_acceptor.close();
}

void CRSocket::CAcceptor::Run(unsigned short nPort)
{
	struct F
	{
		static void OnAccept(CAcceptor &body,boost::shared_ptr<CSocket> spSocket,const boost::system::error_code &error)
			{
				if( error ){
					ATLTRACE(_T("\nOnAccept error"));
					body.OnError( spSocket, error );	// G[ʒm
					return;
				}
				Accept(body);							// AcceptJn
				body.OnAccept(spSocket);				// ʒm
			}
		static void Accept(CAcceptor &body)
			{
				asio::ip::tcp::acceptor &acceptor = body.m_acceptor;
				asio::io_service &ioService = acceptor.get_io_service();

				const boost::shared_ptr<CSocket> spSocket( body.OnCreateSocket(ioService).release() );		// Socketp
				if( spSocket ){
					acceptor.async_accept(					// AcceptJn(񓯊)
						spSocket->m_socket,
						boost::bind(&F::OnAccept,boost::ref(body),spSocket,_1));
				}else{
					BOOST_ASSERT(false);
				}
			}
		static void Init(CAcceptor &body,unsigned short nPort)
			{
				asio::ip::tcp::acceptor &acceptor = body.m_acceptor;
				acceptor.open( asio::ip::tcp::v4() );
				acceptor.bind( asio::ip::tcp::endpoint(asio::ip::tcp::v4(),nPort) );
				acceptor.listen();
				Accept(body);							// AcceptJn
			}
	};
	m_acceptor.get_io_service().post( boost::bind(&F::Init,boost::ref(*this),nPort) );
}
