#pragma once
#include "stdafx.h"

class CRSocket
{
public:
	class CAcceptor;

	class CSocket
		:private boost::noncopyable
	{
		friend class CAcceptor;
		boost::asio::ip::tcp::socket	m_socket;
	public:
		CSocket(boost::asio::io_service &ioService)
			:m_socket(ioService)
			{}
		// T[o[ɐڑ
		void Connect(const std::string &sDomain,const std::string &sPort);
		// M
		void Send(boost::shared_ptr<const std::vector<char>> spData);
		// ǂݍݑ҂̊Jn
		void Read();

		const boost::asio::ip::tcp::socket::endpoint_type GetRemoteEndpoint()const
			{
				return m_socket.remote_endpoint();
			}

		// pnh쐬
		SOCKET CreateDuplicateHandle()
			{
				WSAPROTOCOL_INFO pi = {0,};
				::WSADuplicateSocket( m_socket.native(), GetCurrentProcessId(), &pi);
				SOCKET h = ::WSASocket( pi.iAddressFamily, pi.iSocketType,pi.iProtocol, &pi, 0, 0 );
				m_socket.close();
				return h;
			}
		// pnh畡
		void Assign(SOCKET hSocket)
			{
				m_socket.assign( boost::asio::ip::tcp::v4(), hSocket );
			}

	protected:
		virtual void OnDataReceive(const boost::shared_ptr<const std::vector<char>> &spBuffer)
			{}
		virtual void OnConnect()
			{}
		virtual void OnError(const boost::system::error_code &error)
			{}
	};

	class CAcceptor
		:private boost::noncopyable
	{
		boost::asio::ip::tcp::acceptor	m_acceptor;
	public:
		CAcceptor(boost::asio::io_service &ioService);
		virtual ~CAcceptor();

		void Run(unsigned short nPort=80);
		void Close();
	protected:
		virtual std::auto_ptr<CSocket> OnCreateSocket(boost::asio::io_service &ioService)
			{
				return std::auto_ptr<CSocket>(new CSocket(ioService));
			}
		virtual void OnError(boost::shared_ptr<CSocket> spSocket,const boost::system::error_code &error)
			{}
		virtual void OnAccept(boost::shared_ptr<CSocket> spSocket)
			{}
	};

};

