#pragma once

namespace RLib
{

// UIXbhɒʒm
// E
// ex)	class CSub : public CRPostSignalToUIThread{	// CRPostSignalToUIThread {NXɂ
//			virtual void OnAsyncSignal();			// Mnh(OnAsyncSignal)I[o[Ch
//		};
//		EEEEEEEEE
//		pSub->PostSingnal();		// ʃXbh|XgBXbhłB(񓯊)
class CRPostSignalToUIThread
	:private boost::noncopyable
{
	class CInner;
	CInner	&m_inner;
protected:
	virtual void OnReceiveSignal()=0{}
	CRPostSignalToUIThread();
public:
	virtual ~CRPostSignalToUIThread();
	void PostSingnal();
	size_t GetSignalCount()const;
	void ResetSignalCount();
};


// UIXbhɃbZ[Wʒm
// E
// ex)	class CSub : public CRPostMessageToUIThread<std::string>{				// CRPostSignalToUIThread {NXɂ
//			virtual void OnReceiveMessage(std::list<std::string> &listMessage);	// Mnh(OnAsyncMessage)I[o[Ch
//		};
//		EEEEEEEEE
//		pSub->PostMessage("abc");	// ʃXbh|XgBXbhłB(񓯊)
template <class TMessage> class CRPostMessageToUIThread
	:private boost::noncopyable
{
	class CSignal : public CRPostSignalToUIThread
	{
		void OnReceiveSignal()
			{
				std::list<TMessage>	l;
				{
					boost::mutex::scoped_lock lk(m_host.m_message.mtx);
					m_host.m_message.list.swap( l );
				}
				if( !l.empty() ) m_host.OnReceiveMessage(l);
			}
	public:
		CRPostMessageToUIThread<TMessage>	&m_host;
		CSignal(CRPostMessageToUIThread<TMessage> &host)
			:m_host(host)
			{}
	}m_signal;
	struct{
		std::list<TMessage>	list;
		boost::mutex		mtx;
	}m_message;
protected:
	virtual void OnReceiveMessage(std::list<TMessage> &listMessage)=0{}
	CRPostMessageToUIThread()
		:m_signal(*this)
		{
		}
public:
	void PostMessage(const TMessage &message)
		{
			{
				boost::mutex::scoped_lock lk(m_message.mtx);
				m_message.list.push_back(message);
			}
			m_signal.PostSingnal();
		}
};

}

