#include "stdafx.h"

#include "RPostMessageToUIThread.h"
#include "RRefer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace RLib;

class CRPostSignalToUIThread::CInner
	:public CRRefer<CInner>::CBase
{
	struct CClient
	{
		CRRefer<CInner>	m_rInner;
		bool			m_bProcessing;
	public:
		CClient()
			:m_bProcessing(false)
			{}
	};

	class CWindow
		:public CWindowImpl<CWindow>
	{
	   LRESULT OnMessage(UINT uMsg,WPARAM wParam,LPARAM lParam,BOOL &bHandled)
			{
				for(std::list<CClient>::iterator i=m_listInner.begin(); i!=m_listInner.end(); ){
					CClient &c = *i;
					if( c.m_bProcessing ){
						i++;
					}else{
						if( CInner *pInner = c.m_rInner.Get() ){
							i++;
							{// ʒm
								bool bNotify = false;
								{
									boost::mutex::scoped_lock lk(pInner->m_count.mtx);
									BOOST_VERIFY( pInner->m_count.nPost > 0 );
									pInner->m_count.nPost--;
									if( pInner->m_count.nSignal > 0 ){
										pInner->m_count.nSignal--;
										bNotify = true;
									}
								}
								if( bNotify ){
									c.m_bProcessing = true;
									pInner->m_host.OnReceiveSignal();	// ʒm
									c.m_bProcessing = false;
								}
							}
						}else{
							i = m_listInner.erase(i);
						}
					}
				}
				return 0;
			}
	public:
		DECLARE_WND_CLASS( _T("CAsyncEventToUIThread Window") );
		std::list<CClient>	m_listInner;
		BEGIN_MSG_MAP(T)
			MESSAGE_HANDLER(m_nMessage, OnMessage)
		END_MSG_MAP()
		CWindow()
			{
				Create(HWND_MESSAGE,CRect(0,0,0,0),_T(""),NULL);
			}
		~CWindow()
			{
				if( m_hWnd ) DestroyWindow();
			}
	};
	boost::thread_specific_ptr<CWindow>	m_tspWindow;
public:
	static const UINT		m_nMessage;
	CRPostSignalToUIThread	&m_host;
	struct{
		size_t			nPost;			// PostMessageJEg
		size_t			nSignal;		// ʒmJEg
		boost::mutex	mtx;
	}m_count;
	HWND				m_hWnd;
public:
	CInner(CRPostSignalToUIThread &host)
		:m_host(host)
		,m_hWnd(NULL)
		{
			m_count.nPost = 0;
			m_count.nSignal = 0;
			CWindow *pWindow = m_tspWindow.get();
			if( !pWindow ){
				pWindow = new CWindow;
				m_tspWindow.reset(pWindow);
			}
			m_hWnd = pWindow->m_hWnd;
			
			CClient c;
			c.m_rInner = CRRefer<CInner>(*this);
			pWindow->m_listInner.push_back(c);
		}
};
const UINT CRPostSignalToUIThread::CInner::m_nMessage = ::RegisterWindowMessage( CString(typeid(CRPostSignalToUIThread).name()) + _T(" Message") );

CRPostSignalToUIThread::CRPostSignalToUIThread()
:m_inner(*new CInner(*this))
{}

CRPostSignalToUIThread::~CRPostSignalToUIThread()
{
	delete &m_inner;
}

void CRPostSignalToUIThread::PostSingnal()
{
	bool bPost = false;
	{
		boost::mutex::scoped_lock lk(m_inner.m_count.mtx);
		m_inner.m_count.nSignal++;
		if( m_inner.m_count.nPost < 2 ){		// Q܂ł Post 
			m_inner.m_count.nPost++;
			bPost = true;
		}
	}
	if( bPost ){
		BOOST_VERIFY( ::PostMessage(m_inner.m_hWnd,CInner::m_nMessage,0,0) );
	}
}

size_t CRPostSignalToUIThread::GetSignalCount()const
{
	boost::mutex::scoped_lock lk(m_inner.m_count.mtx);
	return m_inner.m_count.nSignal;
}

void CRPostSignalToUIThread::ResetSignalCount()
{
	boost::mutex::scoped_lock lk(m_inner.m_count.mtx);
	m_inner.m_count.nSignal = 0;
}
