
// ChatTrialDocClient.cpp : CChatTrialDocClient NX̎
//

#include "stdafx.h"
#include "ChatTrial.h"

#include "ChatTrialDocClient.h"
#include "CntrItem.h"

#include "DlgClient.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CChatTrialDocClient

IMPLEMENT_DYNCREATE(CChatTrialDocClient, CRichEditDoc)

BEGIN_MESSAGE_MAP(CChatTrialDocClient, CRichEditDoc)
	//  OLE ReiLɂ܂B
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, &CRichEditDoc::OnUpdateEditLinksMenu)
	ON_COMMAND(ID_OLE_EDIT_LINKS, &CRichEditDoc::OnEditLinks)
	ON_UPDATE_COMMAND_UI_RANGE(ID_OLE_VERB_FIRST, ID_OLE_VERB_LAST, &CRichEditDoc::OnUpdateObjectVerbMenu)
END_MESSAGE_MAP()


// CChatTrialDocClient RXgNV/fXgNV

CChatTrialDocClient::CChatTrialDocClient()
{
}

CChatTrialDocClient::~CChatTrialDocClient()
{
	if( m_spClient ) m_spClient->Stop();
}

BOOL CChatTrialDocClient::OnNewDocument()
{
	if (!__super::OnNewDocument())
		return FALSE;

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)

	CString sHost,sPort;
	{
		CDlgClient dlg;
		dlg.m_sHost = _T("localhost");
		dlg.m_sPort = _T("10000");
		if( dlg.DoModal() != IDOK ){
			return FALSE;
		}
		sHost = dlg.m_sHost;
		sPort = dlg.m_sPort;
	}

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)

	class CClient
		:public CChat::CClient
	{
		CChatTrialDocClient			&m_doc;
	public:
		CClient(CChatTrialDocClient &doc,const char *sDomain,const char *sPort)
			:CChat::CClient()
			,m_doc(doc)
			{
				Run(sDomain,sPort);	// Jn
			}
	protected:
		virtual void OnDataReceive(const std::vector<char> &vData)
			{
				__super::OnDataReceive(vData);

				CString sMessage;
				{
					std::vector<char> v(vData);
					v.push_back(NULL);
					sMessage = CString(&v[0]);
				}

				CString s;
				s.Format(_T("%s"),sMessage);

				m_doc.PostMessage(s);
			}

		// OnhBXbhŃR[BI[o[ChׂB
		virtual void OnErrorException(const std::exception &error)
			{
				__super::OnErrorException(error);

				CString s;
				s.Format(_T("%s"),CString(error.what()));
				m_doc.PostMessage(s);

				ATLTRACE(_T("\n%s"),s);
			}

		// G[nhBXbhŃR[BI[o[ChׂB
		virtual void OnError(const boost::system::error_code &error)
			{
				__super::OnError(error);

				CString s;
				s.Format(_T("%s"),CString(error.message().c_str()));
				m_doc.PostMessage(s);

				ATLTRACE(_T("\n%s"),s);
			}
	};

	try{
		m_spClient = boost::shared_ptr<CChat::CClient>(
			new CClient(
				*this,
				CStringA(sHost).GetBuffer(0),
				CStringA(sPort).GetBuffer(0)));
	}catch( std::exception const &e ){
		::AfxMessageBox(CString(e.what()));
		return FALSE;
	}

	{// hLg^Cgݒ
		CString s;
		s.Format(_T("%s:%s"),sHost,sPort);
		SetTitle(s);
	}

	return TRUE;
}
