
// ChatTrialDocServer.cpp : CChatTrialDocServer NX̎
//

#include "stdafx.h"
#include "ChatTrial.h"

#include "ChatTrialDocServer.h"
#include "CntrItem.h"

#include "DlgServer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CChatTrialDocServer

IMPLEMENT_DYNCREATE(CChatTrialDocServer, CRichEditDoc)

BEGIN_MESSAGE_MAP(CChatTrialDocServer, CRichEditDoc)
	//  OLE ReiLɂ܂B
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, &CRichEditDoc::OnUpdateEditLinksMenu)
	ON_COMMAND(ID_OLE_EDIT_LINKS, &CRichEditDoc::OnEditLinks)
	ON_UPDATE_COMMAND_UI_RANGE(ID_OLE_VERB_FIRST, ID_OLE_VERB_LAST, &CRichEditDoc::OnUpdateObjectVerbMenu)
END_MESSAGE_MAP()


// CChatTrialDocServer RXgNV/fXgNV

CChatTrialDocServer::CChatTrialDocServer()
{
}

CChatTrialDocServer::~CChatTrialDocServer()
{
	if( m_spServer ){
		m_spServer->Stop();
		m_spServer.reset();
	}
}

BOOL CChatTrialDocServer::OnNewDocument()
{
	if (!__super::OnNewDocument())
		return FALSE;

	unsigned short nPort = 10000;
	{
		CDlgServer dlg;
		dlg.m_nPort = nPort;
		if( dlg.DoModal() != IDOK ){
			return FALSE;
		}
		nPort = dlg.m_nPort;
	}

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)


	class CServer : public CChat::CServer
	{
		CChatTrialDocServer			&m_doc;
	public:
		CServer(CChatTrialDocServer &doc)
			:m_doc(doc)
			{}
		// f[^MnhBXbhŃR[BI[o[ChׂB
		virtual void OnDataReceive(boost::asio::ip::tcp::socket	&socket,const std::vector<char> &vData)
			{
				CString sMessage;
				{
					std::vector<char> v(vData);
					v.push_back(NULL);
					sMessage = CString(&v[0]);
				}

				CString sRemoteIp;
				{
					boost::asio::ip::tcp::socket::endpoint_type ep = socket.remote_endpoint();
					boost::asio::ip::address addr = ep.address();
					sRemoteIp = CString(addr.to_string().c_str());
				}

				CString s;
				s.Format(_T("%-15s>%s"),sRemoteIp,sMessage);
				m_doc.PostMessage(s);

				// SclientɑM
				Broadcast(&vData[0],vData.size());
			}

		// G[nhBXbhŃR[BI[o[ChׂB
		virtual void OnAccept(boost::asio::ip::tcp::socket &socket)
			{
				CString sRemoteIp;
				{
					boost::asio::ip::tcp::socket::endpoint_type ep = socket.remote_endpoint();
					boost::asio::ip::address addr = ep.address();
					sRemoteIp = CString(addr.to_string().c_str());
				}

				CString s;
				s.Format(_T("%-15s>Accept"),sRemoteIp);
				m_doc.PostMessage(s);

				ATLTRACE(_T("\n%s"),s);
			}

		// G[nhBXbhŃR[BI[o[ChׂB
		virtual void OnError(boost::asio::ip::tcp::socket &socket,const boost::system::error_code &error)
			{
				CString s;
				s.Format(_T("%s"),CString(error.message().c_str()));
				m_doc.PostMessage(s);

				ATLTRACE(_T("\n%s"),s);
			}
	};

	m_spServer = boost::shared_ptr<CChat::CServer>( new CServer(*this) );
	m_spServer->Run(nPort);

	{// hLg^Cgݒ
		CString s;
		s.Format(_T("server:%d"),nPort);
		SetTitle(s);
	}

	return TRUE;
}
